var WPPBAuthNonce = wppb_2fa_script_vars.WPPBAuthNonce;
var ajaxurl       = wppb_2fa_script_vars.ajaxurl;
var valid         = wppb_2fa_script_vars.valid;
var invalid       = wppb_2fa_script_vars.invalid;

// Backup codes variables
var backupCodes = wppb_2fa_script_vars.backupCodes;
var regenerateBackupCodes = wppb_2fa_script_vars.regenerateBackupCodes;
var copyCodes = wppb_2fa_script_vars.copyCodes;
var downloadCodes = wppb_2fa_script_vars.downloadCodes;
var regenerateConfirm = wppb_2fa_script_vars.regenerateConfirm;
var eachCodeOnce = wppb_2fa_script_vars.eachCodeOnce;
var remainingCodes = wppb_2fa_script_vars.remainingCodes;

jQuery( document ).ready( ShowOrHideFields );

jQuery( '#wppb_auth_enabled' ).on( 'change', ShowOrHideFields );

//Create new secret and display it
jQuery( '#wppb_auth_newsecret' ).on( 'click', function() {
    var data = new Object();
    data['action']	= 'WPPBAuth_new_secret';
    data['nonce']	= WPPBAuthNonce;
    jQuery.post( ajaxurl, data, function( response ) {
        jQuery( '#wppb_auth_secret' ).val( response['new-secret'] );
        var qrcode = 'otpauth://totp/'+escape( jQuery( '#wppb_auth_description' ).val() )+'?secret='+jQuery( '#wppb_auth_secret' ).val();
        // Replace QRCode if one is shown
        if ( jQuery( '#wppb_auth_QR_INFO' ).is( ':visible' ) ) {
            jQuery( '#wppb_auth_QRCODE' ).html( '' );
            jQuery( '#wppb_auth_QRCODE' ).qrcode( qrcode );
        }
    } );
} );

// If the user starts modifying the description, hide the qrcode
jQuery( '#wppb_auth_description' ).on( 'focus blur change keyup', function() {
    // Only remove QR Code if it's visible
    if ( jQuery( '#wppb_auth_QR_INFO' ).is( ':visible' ) ) {
        jQuery( '#wppb_auth_QR_INFO' ).hide();
        jQuery( '#wppb_auth_QRCODE' ).html( '' );
    }
} );

function ShowOrHideFields() {
    if( jQuery( '#wppb_auth_enabled' ).is( ':checked' ) ){
        jQuery( '#wppb_auth_active, .wppb_auth_active' ).show();
    } else {
        jQuery( '#wppb_auth_active, .wppb_auth_active' ).hide();
    }
}

function ShowOrHideQRCode() {
    if ( jQuery( '#wppb_auth_QR_INFO' ).is( ':hidden' ) ) {
        var qrcode = 'otpauth://totp/'+escape( jQuery( '#wppb_auth_description' ).val() )+'?secret='+jQuery( '#wppb_auth_secret' ).val();
        jQuery( '#wppb_auth_QRCODE' ).qrcode( qrcode );
        jQuery( '#wppb_auth_QR_INFO' ).show();
    } else {
        jQuery( '#wppb_auth_QR_INFO' ).hide();
        jQuery( '#wppb_auth_QRCODE' ).html( '' );
    }
}

//Verify TOTP
jQuery( '#wppb_auth_verify_button' ).on( 'click', function() {
    var data = new Object();
    data['action']      = 'WPPBAuth_check_code';
    data['nonce']       = WPPBAuthNonce;
    data['secret']      = jQuery( '#wppb_auth_secret' ).val();
    data['relaxedmode'] = jQuery( '#wppb_auth_relaxedmode' ).val();;
    data['otp']         = jQuery( '#wppb_auth_passw' ).val();;
    jQuery.post( ajaxurl, data, function( response ) {
        if ( response['valid-otp'] ) {
            jQuery( '#wppb_auth_verify_indicator' ).prop('value', valid);
            jQuery( '#wppb_auth_verify_indicator' ).removeClass( 'invalid' ).addClass( 'valid' );
            jQuery( '#wppb_auth_verify_result' ).val( 'valid' );
        } else {
            jQuery( '#wppb_auth_verify_indicator' ).prop('value', invalid);
            jQuery( '#wppb_auth_verify_indicator' ).removeClass( 'valid' ).addClass( 'invalid' );
            jQuery( '#wppb_auth_verify_result' ).val( 'invalid' );
        }
    } );
} );

// Backup Codes Functionality
jQuery(document).ready(function($) {
    
    // Regenerate Backup Codes
    $(document).on('click', '#wppb_auth_backup_button', function() {
        if (confirm(regenerateConfirm)) {
            var button = $(this);
            var originalText = button.text();
            
            button.prop('disabled', true).text('Generating...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'WPPBAuth_regenerate_backup_codes',
                    nonce: WPPBAuthNonce
                },
                success: function(response) {
                    if (response.success) {
                        // Show the newly generated codes immediately
                        showNewBackupCodes(response.data.codes, response.data.message);
                        // Update count
                        $('#wppb_auth_backup_indicator').prop('value', response.data.count + ' ' + remainingCodes).removeClass('low zero');

                    } else {
                        alert(response.data || 'Error regenerating backup codes');
                    }
                },
                error: function() {
                    alert('Error regenerating backup codes');
                },
                complete: function() {
                    button.prop('disabled', false).text(originalText);
                }
            });
        }
    });
    
    // Copy Backup Codes
    $(document).on('click', '#wppb-copy-backup-codes', function() {
        var codesList = $('.wppb-backup-codes-list, .wppb-backup-codes-admin-list');
        var codes = [];
        
        codesList.find('.wppb-backup-code-item, .wppb-backup-codes-admin-item').each(function() {
            codes.push($(this).text().trim());
        });
        
        if (codes.length > 0) {
            var codesText = codes.join('\n');
            
            // Copy to clipboard
            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(codesText);
            }
        }
    });
    
    // Download Backup Codes
    $(document).on('click', '#wppb-download-backup-codes', function() {
        var codesList = $('.wppb-backup-codes-list, .wppb-backup-codes-admin-list');
        var codes = [];
        
        codesList.find('.wppb-backup-code-item, .wppb-backup-codes-admin-item').each(function() {
            codes.push($(this).text().trim());
        });
        
        if (codes.length > 0) {
            var codesText = codes.join('\n');
            var blob = new Blob([codesText], { type: 'text/plain' });
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = 'backup-codes-' + new Date().toISOString().split('T')[0] + '.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);
        }
    });
    
    // Helper function to show newly generated backup codes
    function showNewBackupCodes(codes, message) {
        // Remove any existing new codes section
        $( '.wppb-backup-codes-new, .wppb-backup-codes-admin-new' ).remove();

        // Create the new codes section (works for both admin and frontend)
        var newCodesHtml = '<div class="wppb-backup-codes-new wppb-backup-codes-admin-new">';
        newCodesHtml += '<p><strong>' + message + '</strong></p>';
        newCodesHtml += '<div class="wppb-backup-codes-list wppb-backup-codes-admin-list">';

        codes.forEach( function ( code ) {
            newCodesHtml += '<div class="wppb-backup-code-item wppb-backup-codes-admin-item">' + code + '</div>';
        } );

        newCodesHtml += '</div>';
        newCodesHtml += '<span class="wppb-description-delimiter">' + eachCodeOnce + '</span>';
        newCodesHtml += '<div class="wppb-backup-codes-actions" id="wppb_auth_backup_codes_buttons">';
        newCodesHtml += '<input name="wppb-copy-backup-codes" id="wppb-copy-backup-codes" value="' + copyCodes + '" type="button" class="button" />';
        newCodesHtml += '<input name="wppb-download-backup-codes" id="wppb-download-backup-codes" value="' + downloadCodes + '" type="button" class="button" />';
        newCodesHtml += '</div>';
        newCodesHtml += '</div>';

        // Insert the new codes section
        $( '#wppb_auth_active' ).append( newCodesHtml );
    }
} );